package ELXHBA_DriverParams;
use WSMan::Stubs::Initializable;
use strict;


@ELXHBA_DriverParams::ISA = qw(_Initializable);


#===============================================================================
#			INITIALIZER
#===============================================================================

sub _init{
    my ($self, %args) = @_;
    unless(exists $self->{invokableMethods}){
        $self->{invokableMethods} = {};
    }
    unless(exists $self->{id_keys}){
        $self->{id_keys} = ();
    }
    $self->{paramno} = undef;
    $self->{deviceID} = undef;
    $self->{paramname} = undef;
    $self->{lowRange} = undef;
    $self->{highRange} = undef;
    $self->{def} = undef;
    $self->{current} = undef;
    $self->{exportFlag} = undef;
    $self->{dynamic} = undef;
    $self->{help} = undef;
    $self->{epr_name} = undef;  
    push @{$self->{id_keys}}, 'paramno';
    push @{$self->{id_keys}}, 'deviceID';
    @{$self->{id_keys}} = keys %{{ map { $_ => 1 } @{$self->{id_keys}} }};
    if(keys %args){
        $self->_subinit(%args);
    }
}


#===============================================================================


#===============================================================================
#            paramno accessor method.
#===============================================================================

sub paramno{
    my ($self, $newval) = @_;
    $self->{paramno} = $newval if @_ > 1;
    return $self->{paramno};
}
#===============================================================================


#===============================================================================
#            deviceID accessor method.
#===============================================================================

sub deviceID{
    my ($self, $newval) = @_;
    $self->{deviceID} = $newval if @_ > 1;
    return $self->{deviceID};
}
#===============================================================================


#===============================================================================
#            paramname accessor method.
#===============================================================================

sub paramname{
    my ($self, $newval) = @_;
    $self->{paramname} = $newval if @_ > 1;
    return $self->{paramname};
}
#===============================================================================


#===============================================================================
#            lowRange accessor method.
#===============================================================================

sub lowRange{
    my ($self, $newval) = @_;
    $self->{lowRange} = $newval if @_ > 1;
    return $self->{lowRange};
}
#===============================================================================


#===============================================================================
#            highRange accessor method.
#===============================================================================

sub highRange{
    my ($self, $newval) = @_;
    $self->{highRange} = $newval if @_ > 1;
    return $self->{highRange};
}
#===============================================================================


#===============================================================================
#            def accessor method.
#===============================================================================

sub def{
    my ($self, $newval) = @_;
    $self->{def} = $newval if @_ > 1;
    return $self->{def};
}
#===============================================================================


#===============================================================================
#            current accessor method.
#===============================================================================

sub current{
    my ($self, $newval) = @_;
    $self->{current} = $newval if @_ > 1;
    return $self->{current};
}
#===============================================================================


#===============================================================================
#            exportFlag accessor method.
#===============================================================================

sub exportFlag{
    my ($self, $newval) = @_;
    $self->{exportFlag} = $newval if @_ > 1;
    return $self->{exportFlag};
}
#===============================================================================


#===============================================================================
#            dynamic accessor method.
#===============================================================================

sub dynamic{
    my ($self, $newval) = @_;
    $self->{dynamic} = $newval if @_ > 1;
    return $self->{dynamic};
}
#===============================================================================


#===============================================================================
#            help accessor method.
#===============================================================================

sub help{
    my ($self, $newval) = @_;
    $self->{help} = $newval if @_ > 1;
    return $self->{help};
}
#===============================================================================


#===============================================================================
#           epr_name accessor method.
#===============================================================================

sub epr_name{
    my ($self, $newval) = @_;
    $self->{epr_name} = $newval if @_ > 1;
    return $self->{epr_name};
}
#===============================================================================


1;
