-- MySQL dump 10.14  Distrib 5.5.68-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: nagiosna
-- ------------------------------------------------------
-- Server version	5.5.68-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `nagiosna`
--

/*!40000 DROP DATABASE IF EXISTS `nagiosna`*/;

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `nagiosna` /*!40100 DEFAULT CHARACTER SET latin1 */;

USE `nagiosna`;

--
-- Table structure for table `nagiosna_Checks`
--

DROP TABLE IF EXISTS `nagiosna_Checks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_Checks` (
  `cid` int(11) NOT NULL AUTO_INCREMENT,
  `rawquery` text,
  `name` varchar(100) NOT NULL,
  `warning` varchar(20) DEFAULT NULL,
  `sid` int(11) DEFAULT NULL,
  `gid` int(11) DEFAULT NULL,
  `vid` int(11) DEFAULT NULL,
  `pid` int(11) unsigned DEFAULT NULL,
  `active` tinyint(1) unsigned DEFAULT '1',
  `critical` varchar(20) DEFAULT NULL,
  `aberrant` tinyint(1) unsigned DEFAULT '0',
  `lastval` double DEFAULT NULL,
  `lastrun` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastcode` smallint(6) DEFAULT '3',
  `laststdout` varchar(200) DEFAULT NULL,
  `metric` enum('bytes','flows','packets','bps','pps','bpp','abnormal_behavior','lost_connection','rtt') DEFAULT NULL,
  PRIMARY KEY (`cid`),
  UNIQUE KEY `name` (`name`),
  KEY `sid` (`sid`),
  KEY `vid` (`vid`),
  KEY `gid` (`gid`),
  KEY `pid` (`pid`),
  CONSTRAINT `nagiosna_Checks_ibfk_4` FOREIGN KEY (`pid`) REFERENCES `nagiosna_path_nodes` (`id`),
  CONSTRAINT `nagiosna_Checks_ibfk_1` FOREIGN KEY (`sid`) REFERENCES `nagiosna_Sources` (`sid`),
  CONSTRAINT `nagiosna_Checks_ibfk_2` FOREIGN KEY (`vid`) REFERENCES `nagiosna_Views` (`vid`),
  CONSTRAINT `nagiosna_Checks_ibfk_3` FOREIGN KEY (`gid`) REFERENCES `nagiosna_SourceGroups` (`gid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_Checks`
--

LOCK TABLES `nagiosna_Checks` WRITE;
/*!40000 ALTER TABLE `nagiosna_Checks` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagiosna_Checks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_ChecksCmdLinker`
--

DROP TABLE IF EXISTS `nagiosna_ChecksCmdLinker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_ChecksCmdLinker` (
  `cid` int(11) NOT NULL,
  `cmdid` int(11) NOT NULL,
  PRIMARY KEY (`cid`,`cmdid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_ChecksCmdLinker`
--

LOCK TABLES `nagiosna_ChecksCmdLinker` WRITE;
/*!40000 ALTER TABLE `nagiosna_ChecksCmdLinker` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagiosna_ChecksCmdLinker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_ChecksHSALinker`
--

DROP TABLE IF EXISTS `nagiosna_ChecksHSALinker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_ChecksHSALinker` (
  `cid` int(11) NOT NULL,
  `aid` int(11) NOT NULL,
  PRIMARY KEY (`cid`,`aid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_ChecksHSALinker`
--

LOCK TABLES `nagiosna_ChecksHSALinker` WRITE;
/*!40000 ALTER TABLE `nagiosna_ChecksHSALinker` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagiosna_ChecksHSALinker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_ChecksTrapsLinker`
--

DROP TABLE IF EXISTS `nagiosna_ChecksTrapsLinker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_ChecksTrapsLinker` (
  `cid` int(11) NOT NULL,
  `tid` int(11) NOT NULL,
  PRIMARY KEY (`cid`,`tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_ChecksTrapsLinker`
--

LOCK TABLES `nagiosna_ChecksTrapsLinker` WRITE;
/*!40000 ALTER TABLE `nagiosna_ChecksTrapsLinker` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagiosna_ChecksTrapsLinker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_ChecksUsersLinker`
--

DROP TABLE IF EXISTS `nagiosna_ChecksUsersLinker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_ChecksUsersLinker` (
  `cid` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  PRIMARY KEY (`cid`,`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_ChecksUsersLinker`
--

LOCK TABLES `nagiosna_ChecksUsersLinker` WRITE;
/*!40000 ALTER TABLE `nagiosna_ChecksUsersLinker` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagiosna_ChecksUsersLinker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_Commands`
--

DROP TABLE IF EXISTS `nagiosna_Commands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_Commands` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `location` text,
  `script` varchar(200) DEFAULT NULL,
  `arguments` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_Commands`
--

LOCK TABLES `nagiosna_Commands` WRITE;
/*!40000 ALTER TABLE `nagiosna_Commands` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagiosna_Commands` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_HostServiceAssociations`
--

DROP TABLE IF EXISTS `nagiosna_HostServiceAssociations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_HostServiceAssociations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hostname` varchar(100) NOT NULL,
  `servicename` varchar(100) DEFAULT NULL,
  `serverid` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `serverid` (`serverid`),
  CONSTRAINT `nagiosna_HostServiceAssociations_ibfk_1` FOREIGN KEY (`serverid`) REFERENCES `nagiosna_NagiosServers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_HostServiceAssociations`
--

LOCK TABLES `nagiosna_HostServiceAssociations` WRITE;
/*!40000 ALTER TABLE `nagiosna_HostServiceAssociations` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagiosna_HostServiceAssociations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_NagiosServers`
--

DROP TABLE IF EXISTS `nagiosna_NagiosServers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_NagiosServers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `nrdp` varchar(200) DEFAULT NULL,
  `token` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_NagiosServers`
--

LOCK TABLES `nagiosna_NagiosServers` WRITE;
/*!40000 ALTER TABLE `nagiosna_NagiosServers` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagiosna_NagiosServers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_Queries`
--

DROP TABLE IF EXISTS `nagiosna_Queries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_Queries` (
  `qid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` text,
  `rawquery` text,
  `aggregate_csv` varchar(200) DEFAULT NULL,
  `begindate` varchar(30) NOT NULL,
  `enddate` varchar(30) NOT NULL,
  PRIMARY KEY (`qid`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_Queries`
--

LOCK TABLES `nagiosna_Queries` WRITE;
/*!40000 ALTER TABLE `nagiosna_Queries` DISABLE KEYS */;
INSERT INTO `nagiosna_Queries` VALUES (1,'Common Botnets','Aggregation of the most common ips for botnets.','(ip 213.155.14.161 and port 80) or (ip 59.124.27.180 and port 3305) or (ip 148.81.111.111 and port 65520) or (ip 194.85.61.78 and port 80) or (ip 178.132.202.196 and port 65520)','srcip,dstip','-24 hours','-1 second'),(2,'P2P Traffic','Aggregation of some common P2P traffic ports.','port 21 or port 6346 or port 6347 or port 411 or port 1025 or port 3689','dstip,srcip','-24 hours','-1 second');
/*!40000 ALTER TABLE `nagiosna_Queries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_Reports`
--

DROP TABLE IF EXISTS `nagiosna_Reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_Reports` (
  `rid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `top` smallint(5) unsigned NOT NULL,
  `toptype` varchar(20) NOT NULL,
  `toporder` varchar(20) NOT NULL,
  `begindate` varchar(30) NOT NULL,
  `enddate` varchar(30) NOT NULL,
  `editable` tinyint(1) unsigned DEFAULT '1',
  `rawquery` text,
  PRIMARY KEY (`rid`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_Reports`
--

LOCK TABLES `nagiosna_Reports` WRITE;
/*!40000 ALTER TABLE `nagiosna_Reports` DISABLE KEYS */;
INSERT INTO `nagiosna_Reports` VALUES (1,'Top 5 Talkers By Source IP (Last 24 Hours)',5,'srcip','bytes','-24 hours','-1 second',0,NULL),(2,'Top 5 Talkers By Destination IP (Last 24 Hours)',5,'dstip','bytes','-24 hours','-1 second',0,NULL),(3,'Top 5 Talkers By Source Port (Last 24 Hours)',5,'srcport','bytes','-24 hours','-1 second',0,NULL),(4,'Top 5 Talkers By Destination Port (Last 24 Hours)',5,'dstport','bytes','-24 hours','-1 second',0,NULL);
/*!40000 ALTER TABLE `nagiosna_Reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_SGLinker`
--

DROP TABLE IF EXISTS `nagiosna_SGLinker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_SGLinker` (
  `gid` int(11) NOT NULL,
  `sid` int(11) NOT NULL,
  PRIMARY KEY (`gid`,`sid`),
  KEY `sid` (`sid`),
  CONSTRAINT `nagiosna_SGLinker_ibfk_1` FOREIGN KEY (`sid`) REFERENCES `nagiosna_Sources` (`sid`),
  CONSTRAINT `nagiosna_SGLinker_ibfk_2` FOREIGN KEY (`gid`) REFERENCES `nagiosna_SourceGroups` (`gid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_SGLinker`
--

LOCK TABLES `nagiosna_SGLinker` WRITE;
/*!40000 ALTER TABLE `nagiosna_SGLinker` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagiosna_SGLinker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_SourceGroups`
--

DROP TABLE IF EXISTS `nagiosna_SourceGroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_SourceGroups` (
  `gid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`gid`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_SourceGroups`
--

LOCK TABLES `nagiosna_SourceGroups` WRITE;
/*!40000 ALTER TABLE `nagiosna_SourceGroups` DISABLE KEYS */;
INSERT INTO `nagiosna_SourceGroups` VALUES (1,'All Sources');
/*!40000 ALTER TABLE `nagiosna_SourceGroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_Sources`
--

DROP TABLE IF EXISTS `nagiosna_Sources`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_Sources` (
  `sid` int(11) NOT NULL AUTO_INCREMENT,
  `port` smallint(5) unsigned NOT NULL,
  `addresses` text,
  `name` varchar(255) NOT NULL,
  `flowtype` enum('netflow','sflow') DEFAULT NULL,
  `directory` varchar(255) NOT NULL,
  `lifetime` varchar(20) NOT NULL DEFAULT '2d',
  `disable_abnormal` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`sid`),
  UNIQUE KEY `port` (`port`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `directory` (`directory`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_Sources`
--

LOCK TABLES `nagiosna_Sources` WRITE;
/*!40000 ALTER TABLE `nagiosna_Sources` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagiosna_Sources` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_SourcesViewsLinker`
--

DROP TABLE IF EXISTS `nagiosna_SourcesViewsLinker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_SourcesViewsLinker` (
  `sid` int(11) NOT NULL,
  `vid` int(11) NOT NULL,
  PRIMARY KEY (`sid`,`vid`),
  KEY `vid` (`vid`),
  CONSTRAINT `nagiosna_SourcesViewsLinker_ibfk_1` FOREIGN KEY (`sid`) REFERENCES `nagiosna_Sources` (`sid`),
  CONSTRAINT `nagiosna_SourcesViewsLinker_ibfk_2` FOREIGN KEY (`vid`) REFERENCES `nagiosna_Views` (`vid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_SourcesViewsLinker`
--

LOCK TABLES `nagiosna_SourcesViewsLinker` WRITE;
/*!40000 ALTER TABLE `nagiosna_SourcesViewsLinker` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagiosna_SourcesViewsLinker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_TrapReceivers`
--

DROP TABLE IF EXISTS `nagiosna_TrapReceivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_TrapReceivers` (
  `tid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `version` int(11) NOT NULL,
  `community` varchar(100) DEFAULT NULL,
  `authlevel` varchar(20) DEFAULT NULL,
  `privprotocol` enum('AES','DES') DEFAULT NULL,
  `privpassword` varchar(200) DEFAULT NULL,
  `authprotocol` enum('MD5','SHA') DEFAULT NULL,
  `authpassword` varchar(200) DEFAULT NULL,
  `username` varchar(100) DEFAULT NULL,
  `port` smallint(5) unsigned NOT NULL,
  `ip` varchar(50) NOT NULL,
  PRIMARY KEY (`tid`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_TrapReceivers`
--

LOCK TABLES `nagiosna_TrapReceivers` WRITE;
/*!40000 ALTER TABLE `nagiosna_TrapReceivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagiosna_TrapReceivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_Views`
--

DROP TABLE IF EXISTS `nagiosna_Views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_Views` (
  `vid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `lifetime` varchar(20) NOT NULL DEFAULT '4w',
  `limiter` text,
  PRIMARY KEY (`vid`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_Views`
--

LOCK TABLES `nagiosna_Views` WRITE;
/*!40000 ALTER TABLE `nagiosna_Views` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagiosna_Views` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_auth_servers`
--

DROP TABLE IF EXISTS `nagiosna_auth_servers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_auth_servers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) DEFAULT NULL,
  `name` text,
  `host` varchar(200) DEFAULT NULL,
  `type` enum('ad','ldap') DEFAULT NULL,
  `encryption` enum('none','ssl','tls') DEFAULT NULL,
  `basedn` text,
  `suffix` varchar(160) DEFAULT NULL,
  `controllers` text,
  `port` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_auth_servers`
--

LOCK TABLES `nagiosna_auth_servers` WRITE;
/*!40000 ALTER TABLE `nagiosna_auth_servers` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagiosna_auth_servers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_cf_options`
--

DROP TABLE IF EXISTS `nagiosna_cf_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_cf_options` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `modified` datetime DEFAULT NULL,
  `created_by` mediumint(8) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_cf_options`
--

LOCK TABLES `nagiosna_cf_options` WRITE;
/*!40000 ALTER TABLE `nagiosna_cf_options` DISABLE KEYS */;
INSERT INTO `nagiosna_cf_options` VALUES (1,'2023-09-12 01:08:07',NULL,0,'homits','MTY5NDQ4MDkyMA=='),(2,'2023-09-12 01:08:07',NULL,0,'license_key','NPVNRS-SRQTRV-QPVSSN-QUMOSR-TMUOUP'),(3,'2023-09-12 01:08:40',NULL,0,'is_installed','1'),(4,'2023-09-12 01:08:40',NULL,0,'cache_time','604800');
/*!40000 ALTER TABLE `nagiosna_cf_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_cmdsubsys`
--

DROP TABLE IF EXISTS `nagiosna_cmdsubsys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_cmdsubsys` (
  `id` varchar(30) NOT NULL,
  `timestamp` varchar(30) NOT NULL,
  `command` int(11) unsigned NOT NULL,
  `args` text,
  `processing` tinyint(1) unsigned DEFAULT '0',
  `completed` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_cmdsubsys`
--

LOCK TABLES `nagiosna_cmdsubsys` WRITE;
/*!40000 ALTER TABLE `nagiosna_cmdsubsys` DISABLE KEYS */;
INSERT INTO `nagiosna_cmdsubsys` VALUES ('64ffba185f607','1694480920',1000,'a:1:{s:8:\"timezone\";s:3:\"UTC\";}',1,0);
/*!40000 ALTER TABLE `nagiosna_cmdsubsys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_groups`
--

DROP TABLE IF EXISTS `nagiosna_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_groups` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_groups`
--

LOCK TABLES `nagiosna_groups` WRITE;
/*!40000 ALTER TABLE `nagiosna_groups` DISABLE KEYS */;
INSERT INTO `nagiosna_groups` VALUES (1,'admin','Administrator'),(2,'members','General User');
/*!40000 ALTER TABLE `nagiosna_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_hostname_cache`
--

DROP TABLE IF EXISTS `nagiosna_hostname_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_hostname_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(120) DEFAULT NULL,
  `hostname` varchar(200) DEFAULT NULL,
  `time` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_hostname_cache`
--

LOCK TABLES `nagiosna_hostname_cache` WRITE;
/*!40000 ALTER TABLE `nagiosna_hostname_cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagiosna_hostname_cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_login_attempts`
--

DROP TABLE IF EXISTS `nagiosna_login_attempts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_login_attempts` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varbinary(16) NOT NULL,
  `login` varchar(100) NOT NULL,
  `time` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_login_attempts`
--

LOCK TABLES `nagiosna_login_attempts` WRITE;
/*!40000 ALTER TABLE `nagiosna_login_attempts` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagiosna_login_attempts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_migrations`
--

DROP TABLE IF EXISTS `nagiosna_migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_migrations` (
  `version` int(3) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_migrations`
--

LOCK TABLES `nagiosna_migrations` WRITE;
/*!40000 ALTER TABLE `nagiosna_migrations` DISABLE KEYS */;
INSERT INTO `nagiosna_migrations` VALUES (8);
/*!40000 ALTER TABLE `nagiosna_migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_path_nodes`
--

DROP TABLE IF EXISTS `nagiosna_path_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_path_nodes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `modified` datetime DEFAULT NULL,
  `x` float NOT NULL,
  `y` float NOT NULL,
  `name` varchar(255) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `type` int(2) DEFAULT '0',
  `token` varchar(255) DEFAULT NULL,
  `port` int(11) DEFAULT NULL,
  `source` int(11) DEFAULT NULL,
  `reachability` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_path_nodes`
--

LOCK TABLES `nagiosna_path_nodes` WRITE;
/*!40000 ALTER TABLE `nagiosna_path_nodes` DISABLE KEYS */;
INSERT INTO `nagiosna_path_nodes` VALUES (1,'2024-05-22 22:10:21','2024-05-22 22:10:21',650,350,'NNA','localhost',2,NULL,NULL,NULL,0);
/*!40000 ALTER TABLE `nagiosna_path_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_path_status`
--

DROP TABLE IF EXISTS `nagiosna_path_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_path_status` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `modified` datetime NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `rtt` float NOT NULL,
  `hop_number` int(11) NOT NULL,
  `target_node` int(11) NOT NULL,
  `reachability` int(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_path_status`
--

LOCK TABLES `nagiosna_path_status` WRITE;
/*!40000 ALTER TABLE `nagiosna_path_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagiosna_path_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_usermeta`
--

DROP TABLE IF EXISTS `nagiosna_usermeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_usermeta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_usermeta`
--

LOCK TABLES `nagiosna_usermeta` WRITE;
/*!40000 ALTER TABLE `nagiosna_usermeta` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagiosna_usermeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_users`
--

DROP TABLE IF EXISTS `nagiosna_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_users` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varbinary(16) DEFAULT NULL,
  `username` varchar(100) NOT NULL,
  `password` varchar(80) NOT NULL,
  `salt` varchar(40) DEFAULT NULL,
  `email` varchar(100) NOT NULL,
  `activation_code` varchar(40) DEFAULT NULL,
  `forgotten_password_code` varchar(40) DEFAULT NULL,
  `forgotten_password_time` int(11) unsigned DEFAULT NULL,
  `remember_code` varchar(40) DEFAULT NULL,
  `created_on` int(11) unsigned NOT NULL,
  `last_login` int(11) unsigned DEFAULT NULL,
  `active` tinyint(1) unsigned DEFAULT NULL,
  `first_name` varchar(50) DEFAULT NULL,
  `last_name` varchar(50) DEFAULT NULL,
  `company` varchar(100) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `apiaccess` tinyint(1) unsigned DEFAULT '0',
  `apikey` varchar(128) DEFAULT NULL,
  `lang` varchar(20) DEFAULT 'english',
  `type` varchar(100) DEFAULT 'local',
  `auth_server_id` int(11) DEFAULT NULL,
  `auth_server_data` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_users`
--

LOCK TABLES `nagiosna_users` WRITE;
/*!40000 ALTER TABLE `nagiosna_users` DISABLE KEYS */;
INSERT INTO `nagiosna_users` VALUES (1,'\0\0','nagiosadmin','e6695ec8fc8c74eba0c56bf40201b0922410ff96','','jhigueros@genezzight.com','',NULL,NULL,NULL,1268889823,1716419570,1,'','','','',1,'8cf6b86d8cf33c73363cd814c8e156d3e6207e3c','default','local',NULL,NULL);
/*!40000 ALTER TABLE `nagiosna_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nagiosna_users_groups`
--

DROP TABLE IF EXISTS `nagiosna_users_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nagiosna_users_groups` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL,
  `group_id` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_users_groups` (`user_id`,`group_id`),
  KEY `fk_users_groups_users1_idx` (`user_id`),
  KEY `fk_users_groups_groups1_idx` (`group_id`),
  CONSTRAINT `fk_users_groups_groups1` FOREIGN KEY (`group_id`) REFERENCES `nagiosna_groups` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `fk_users_groups_users1` FOREIGN KEY (`user_id`) REFERENCES `nagiosna_users` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `nagiosna_users_groups`
--

LOCK TABLES `nagiosna_users_groups` WRITE;
/*!40000 ALTER TABLE `nagiosna_users_groups` DISABLE KEYS */;
INSERT INTO `nagiosna_users_groups` VALUES (1,1,1);
/*!40000 ALTER TABLE `nagiosna_users_groups` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-05-22 23:13:17
