# OpensSM SystemD service

OpenSM service has 2 options
- Single instance service (default): opensmd.service
- Multi instance service: opensmd@.service

Both _opensmd_ and _opensm_ are valid names for the same service. This also valid for *Multi instance service*

Both services are disabled dy default. i.e. it won't start on boot

## Single instance service

Standard service starts OpenSM with default settings.

If `/etc/opensm/opensm.conf` file exists, uses it as configuration file.

**Note:** this service is mutually exclusive with *Multi instance service*

## Multi instance service

This service allows to natively run multiple OpenSM services at the same time

To run service instance one have to execute `systemctl start systemd@<ID>.service` where `<ID>` is a service clear identifier (can be any string)

Prerequisites:
1. `/etc/opensm/opensm<ID>.conf` configuration file should exists prior to `systemctl start` command execution
1. All instance configuration files should be written in such ways that instances won't interfere with one another. For example:
    - Provide unique bind port guid
    - Provide unique log and dump files
    - If both SM should serve different subnets, configure different subnet prefixes (network prefix is IP terminology)

**Note:** this service is mutually exclusive with *Single instance service*
