# Scope feature for ibdiagnet

## Scope

Feature is valid for ibdaignet.

## Description

Scope feature allows ibdiagnet to run diagnostics only on part of the subnet, or avoid running diagnostics on part of the subnet (exclude).
When feature enabled, ibdiagnet will perform full discovery, parse scope file, and perform other diagnostic stages only on the selected part of the subnet.

Note: routing stage may present routing errors when routes from/to some nodes use excluded switches.

## Parameters

**\-\-scope &lt;scope file&gt;**
Define scope file with devices to include in diagnostic stages.

**\-\-exclude_scope &lt;scope file&gt;**
Define scope file with devices to exclude in diagnostic stages.

## Scope file

### File name

File must end with **.guid** suffix.

### File format:

Scope file consist file format version and list of nodes to include in the scope, according to the following syntax:
- **version:&lt;format version number&gt;** - Scope file format version, must be first line of the file.
Supported version 1.0
- Comment lines start with **#**.
- Nodes line of the following formats:
  - **&lt;Node GUID&gt;** - Include node with specified node GUID with all it ports.
  - **&lt;Node GUID&gt;**@**port1/port2/...** - Include only the specified ports of specified node.
    Note: When using exclude scope option, only the specified ports of the node will be excluded.
  - **ALL_SWITCHES** - Include all switches with all ports in the scope.
  - **ALL_CAS** - Include all HCAs in the scope.
  - **ALL_ROUTERS** - Include all routers in the scope.

### Examples

 Define scope for nodes with Node GUIDs 0x10001, 0x10002, 0x10003 with all their ports:
```
version: 1.0
0x10001
0x10002
0x10003
```

Define scope for ports 1,2,17 of node with Node GUID 0x10002:
```
version: 1.0
0x10002@1/2/17
```

Define scope for all switches (with all their ports):
```
version: 1.0
ALL_SWITCHES
```

Define scope for all CAs:
```
version: 1.0
ALL_CAS
```

Define scope for all Routers:
```
version: 1.0
ALL_ROUTERS
```


Define scope with all of the following nodes:
 -  node with Node GUIDs 0x10001
 - port 1,2,17 of node with Node GUID 0x10002
 - All CAs

```
version: 1.0
0x10001
0x10002@1/2/17
ALL_CAS
```

