# Copyright (C) Nov 2020 Mellanox Technologies Ltd. All rights reserved.
# Copyright (c) 2021 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
#
# This software is available to you under a choice of one of two
# licenses.  You may choose to be licensed under the terms of the GNU
# General Public License (GPL) Version 2, available from the file
# COPYING in the main directory of this source tree, or the
# OpenIB.org BSD license below:
#
#     Redistribution and use in source and binary forms, with or
#     without modification, are permitted provided that the following
#     conditions are met:
#
#      - Redistributions of source code must retain the above
#        copyright notice, this list of conditions and the following
#        disclaimer.
#
#      - Redistributions in binary form must reproduce the above
#        copyright notice, this list of conditions and the following
#        disclaimer in the documentation and/or other materials
#        provided with the distribution.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
# --

import ctypes

from dev_mgt import DEV_MGT  # noqa
from mtcr import MstDevice  # noqa

from .stetypes import MSTDeviceInfo


################################################################################
# Python functions
################################################################################
def get_mst_device_info(device_name):
    """Returns an information about the given MST device.

    :param device_name: The name of the MST device
    :return: An information about MST device.
    :rtype: MSTDeviceInfo
    """
    mst_device = MstDevice(device_name)
    dev_type_enum = ctypes.c_uint(0)
    dev_type_enum_p = ctypes.pointer(dev_type_enum)
    hw_dev_id = ctypes.c_uint(0)
    hw_dev_id_p = ctypes.pointer(hw_dev_id)
    chip_rev = ctypes.c_uint(0)
    chip_rev_p = ctypes.pointer(chip_rev)
    get_device_id(mst_device.mf, dev_type_enum_p, hw_dev_id_p, chip_rev_p)
    dev_type = dev_type2str(dev_type_enum).decode('utf-8')
    return MSTDeviceInfo(device_name, hw_dev_id.value, dev_type)


def get_hw_dev_id(device_name):
    """Returns the hardware device ID of the given MST device.

    :param device_name: The name of the MST device
    :return: Hardware device ID.
    :rtype: int
    """
    return get_mst_device_info(device_name).hw_dev_id


################################################################################
# C functions
################################################################################
# get information about device
get_device_id = DEV_MGT.dm_get_device_id

# get device type as string
dev_type2str = DEV_MGT.dm_dev_type2str
dev_type2str.restype = ctypes.c_char_p
