#!/usr/bin/env bash
###############################################################################
#
# Bash Remediation Script for CUSP - Common User Security Profile for Mozilla Firefox
#
# Profile Description:
# This profile contains rules to harden Mozilla Firefox according to rule 6.1 in the Common User Security Guide for Fedora Workstation.
#
# Profile ID:  xccdf_org.ssgproject.content_profile_cusp_firefox
# Benchmark ID:  xccdf_org.ssgproject.content_benchmark_FIREFOX
# Benchmark Version:  0.1.70
# XCCDF Version:  1.2
#
# This file can be generated by OpenSCAP using:
# $ oscap xccdf generate fix --profile xccdf_org.ssgproject.content_profile_cusp_firefox --fix-type bash ssg-firefox-ds.xml
#
# This Bash Remediation Script is generated from an XCCDF profile without preliminary evaluation.
# It attempts to fix every selected rule, even if the system is already compliant.
#
# How to apply this Bash Remediation Script:
# $ sudo ./remediation-script.sh
#
###############################################################################

###############################################################################
# BEGIN fix (1 / 9) for 'xccdf_org.ssgproject.content_rule_firefox_policy-autoplay_video'
###############################################################################
(>&2 echo "Remediating rule 1/9: 'xccdf_org.ssgproject.content_rule_firefox_policy-autoplay_video'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'Permissions' in _tree['policies']:
   pass
else:
   _tree['policies']['Permissions'] = dict()

if 'Autoplay' in _tree['policies']['Permissions']:
   pass
else:
   _tree['policies']['Permissions']['Autoplay'] = dict()

_tree['policies']['Permissions']['Autoplay']['Default'] = 'block-audio-video'

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-autoplay_video'

###############################################################################
# BEGIN fix (2 / 9) for 'xccdf_org.ssgproject.content_rule_firefox_policy-content_blocker'
###############################################################################
(>&2 echo "Remediating rule 2/9: 'xccdf_org.ssgproject.content_rule_firefox_policy-content_blocker'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'ExtensionSettings' in _tree['policies']:
   pass
else:
   _tree['policies']['ExtensionSettings'] = dict()

if 'uBlock0@raymondhill.net' in _tree['policies']['ExtensionSettings']:
   pass
else:
   _tree['policies']['ExtensionSettings']['uBlock0@raymondhill.net'] = dict()

_tree['policies']['ExtensionSettings']['uBlock0@raymondhill.net']['installation_mode'] = 'normal_installed'


if 'ExtensionSettings' in _tree['policies']:
   pass
else:
   _tree['policies']['ExtensionSettings'] = dict()

if 'uBlock0@raymondhill.net' in _tree['policies']['ExtensionSettings']:
   pass
else:
   _tree['policies']['ExtensionSettings']['uBlock0@raymondhill.net'] = dict()

_tree['policies']['ExtensionSettings']['uBlock0@raymondhill.net']['install_url'] = 'https://addons.mozilla.org/firefox/downloads/latest/ublock-origin/latest.xpi'


if 'ExtensionSettings' in _tree['policies']:
   pass
else:
   _tree['policies']['ExtensionSettings'] = dict()

if 'uBlock0@raymondhill.net' in _tree['policies']['ExtensionSettings']:
   pass
else:
   _tree['policies']['ExtensionSettings']['uBlock0@raymondhill.net'] = dict()

_tree['policies']['ExtensionSettings']['uBlock0@raymondhill.net']['updates_disabled'] = False

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-content_blocker'

###############################################################################
# BEGIN fix (3 / 9) for 'xccdf_org.ssgproject.content_rule_firefox_policy-cryptomining'
###############################################################################
(>&2 echo "Remediating rule 3/9: 'xccdf_org.ssgproject.content_rule_firefox_policy-cryptomining'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'EnableTrackingProtection' in _tree['policies']:
   pass
else:
   _tree['policies']['EnableTrackingProtection'] = dict()

_tree['policies']['EnableTrackingProtection']['Cryptomining'] = True

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-cryptomining'

###############################################################################
# BEGIN fix (4 / 9) for 'xccdf_org.ssgproject.content_rule_firefox_policy-enhanced_tracking'
###############################################################################
(>&2 echo "Remediating rule 4/9: 'xccdf_org.ssgproject.content_rule_firefox_policy-enhanced_tracking'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'Preferences' in _tree['policies']:
   pass
else:
   _tree['policies']['Preferences'] = dict()

if 'browser.contentblocking.category' in _tree['policies']['Preferences']:
   pass
else:
   _tree['policies']['Preferences']['browser.contentblocking.category'] = dict()

_tree['policies']['Preferences']['browser.contentblocking.category']['Value'] = 'strict'


if 'Preferences' in _tree['policies']:
   pass
else:
   _tree['policies']['Preferences'] = dict()

if 'browser.contentblocking.category' in _tree['policies']['Preferences']:
   pass
else:
   _tree['policies']['Preferences']['browser.contentblocking.category'] = dict()

_tree['policies']['Preferences']['browser.contentblocking.category']['Status'] = 'locked'

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-enhanced_tracking'

###############################################################################
# BEGIN fix (5 / 9) for 'xccdf_org.ssgproject.content_rule_firefox_policy-fingerprinting_protection'
###############################################################################
(>&2 echo "Remediating rule 5/9: 'xccdf_org.ssgproject.content_rule_firefox_policy-fingerprinting_protection'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'EnableTrackingProtection' in _tree['policies']:
   pass
else:
   _tree['policies']['EnableTrackingProtection'] = dict()

_tree['policies']['EnableTrackingProtection']['Fingerprinting'] = True

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-fingerprinting_protection'

###############################################################################
# BEGIN fix (6 / 9) for 'xccdf_org.ssgproject.content_rule_firefox_policy-javascript_window_changes'
###############################################################################
(>&2 echo "Remediating rule 6/9: 'xccdf_org.ssgproject.content_rule_firefox_policy-javascript_window_changes'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'Preferences' in _tree['policies']:
   pass
else:
   _tree['policies']['Preferences'] = dict()

if 'dom.disable_window_flip' in _tree['policies']['Preferences']:
   pass
else:
   _tree['policies']['Preferences']['dom.disable_window_flip'] = dict()

_tree['policies']['Preferences']['dom.disable_window_flip']['Value'] = True


if 'Preferences' in _tree['policies']:
   pass
else:
   _tree['policies']['Preferences'] = dict()

if 'dom.disable_window_flip' in _tree['policies']['Preferences']:
   pass
else:
   _tree['policies']['Preferences']['dom.disable_window_flip'] = dict()

_tree['policies']['Preferences']['dom.disable_window_flip']['Status'] = 'locked'

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-javascript_window_changes'

###############################################################################
# BEGIN fix (7 / 9) for 'xccdf_org.ssgproject.content_rule_firefox_policy-javascript_window_resizing'
###############################################################################
(>&2 echo "Remediating rule 7/9: 'xccdf_org.ssgproject.content_rule_firefox_policy-javascript_window_resizing'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'Preferences' in _tree['policies']:
   pass
else:
   _tree['policies']['Preferences'] = dict()

if 'dom.disable_window_move_resize' in _tree['policies']['Preferences']:
   pass
else:
   _tree['policies']['Preferences']['dom.disable_window_move_resize'] = dict()

_tree['policies']['Preferences']['dom.disable_window_move_resize']['Value'] = True


if 'Preferences' in _tree['policies']:
   pass
else:
   _tree['policies']['Preferences'] = dict()

if 'dom.disable_window_move_resize' in _tree['policies']['Preferences']:
   pass
else:
   _tree['policies']['Preferences']['dom.disable_window_move_resize'] = dict()

_tree['policies']['Preferences']['dom.disable_window_move_resize']['Status'] = 'locked'

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-javascript_window_resizing'

###############################################################################
# BEGIN fix (8 / 9) for 'xccdf_org.ssgproject.content_rule_firefox_policy-pop-up_windows'
###############################################################################
(>&2 echo "Remediating rule 8/9: 'xccdf_org.ssgproject.content_rule_firefox_policy-pop-up_windows'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'PopupBlocking' in _tree['policies']:
   pass
else:
   _tree['policies']['PopupBlocking'] = dict()

_tree['policies']['PopupBlocking']['Default'] = True


if 'PopupBlocking' in _tree['policies']:
   pass
else:
   _tree['policies']['PopupBlocking'] = dict()

_tree['policies']['PopupBlocking']['Locked'] = True

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-pop-up_windows'

###############################################################################
# BEGIN fix (9 / 9) for 'xccdf_org.ssgproject.content_rule_firefox_policy-ssl_minimum_version'
###############################################################################
(>&2 echo "Remediating rule 9/9: 'xccdf_org.ssgproject.content_rule_firefox_policy-ssl_minimum_version'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


_tree['policies']['SSLVersionMin'] = 'tls1.2'

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-ssl_minimum_version'

