#!/usr/bin/env bash
###############################################################################
#
# Bash Remediation Script for Mozilla Firefox STIG
#
# Profile Description:
# This profile is developed under the DoD consensus model and DISA FSO Vendor STIG process,
# serving as the upstream development environment for the Firefox STIG.
# As a result of the upstream/downstream relationship between the SCAP Security Guide project
# and the official DISA FSO STIG baseline, users should expect variance between SSG and DISA FSO content.
# For official DISA FSO STIG content, refer to https://public.cyber.mil/stigs/downloads/?_dl_facet_stigs=app-security%2Cbrowser-guidance.
# While this profile is packaged by Red Hat as part of the SCAP Security Guide package, please note
# that commercial support of this SCAP content is NOT available. This profile is provided as example
# SCAP content with no endorsement for suitability or production readiness. Support for this
# profile is provided by the upstream SCAP Security Guide community on a best-effort basis. The
# upstream project homepage is https://www.open-scap.org/security-policies/scap-security-guide/.
#
# Profile ID:  xccdf_org.ssgproject.content_profile_stig
# Benchmark ID:  xccdf_org.ssgproject.content_benchmark_FIREFOX
# Benchmark Version:  0.1.70
# XCCDF Version:  1.2
#
# This file can be generated by OpenSCAP using:
# $ oscap xccdf generate fix --profile xccdf_org.ssgproject.content_profile_stig --fix-type bash ssg-firefox-ds.xml
#
# This Bash Remediation Script is generated from an XCCDF profile without preliminary evaluation.
# It attempts to fix every selected rule, even if the system is already compliant.
#
# How to apply this Bash Remediation Script:
# $ sudo ./remediation-script.sh
#
###############################################################################

###############################################################################
# BEGIN fix (1 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-addons_permission'
###############################################################################
(>&2 echo "Remediating rule 1/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-addons_permission'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'InstallAddonsPermission' in _tree['policies']:
   pass
else:
   _tree['policies']['InstallAddonsPermission'] = dict()

_tree['policies']['InstallAddonsPermission']['Default'] = False

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-addons_permission'

###############################################################################
# BEGIN fix (2 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-autoplay_video'
###############################################################################
(>&2 echo "Remediating rule 2/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-autoplay_video'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'Permissions' in _tree['policies']:
   pass
else:
   _tree['policies']['Permissions'] = dict()

if 'Autoplay' in _tree['policies']['Permissions']:
   pass
else:
   _tree['policies']['Permissions']['Autoplay'] = dict()

_tree['policies']['Permissions']['Autoplay']['Default'] = 'block-audio-video'

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-autoplay_video'

###############################################################################
# BEGIN fix (3 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-cryptomining'
###############################################################################
(>&2 echo "Remediating rule 3/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-cryptomining'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'EnableTrackingProtection' in _tree['policies']:
   pass
else:
   _tree['policies']['EnableTrackingProtection'] = dict()

_tree['policies']['EnableTrackingProtection']['Cryptomining'] = True

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-cryptomining'

###############################################################################
# BEGIN fix (4 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-development_tools'
###############################################################################
(>&2 echo "Remediating rule 4/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-development_tools'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


_tree['policies']['DisableDeveloperTools'] = True

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-development_tools'

###############################################################################
# BEGIN fix (5 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-disable_deprecated_ciphers'
###############################################################################
(>&2 echo "Remediating rule 5/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-disable_deprecated_ciphers'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'DisabledCiphers' in _tree['policies']:
   pass
else:
   _tree['policies']['DisabledCiphers'] = dict()

_tree['policies']['DisabledCiphers']['TLS_RSA_WITH_3DES_EDE_CBC_SHA'] = True

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-disable_deprecated_ciphers'

###############################################################################
# BEGIN fix (6 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-disable_form_history'
###############################################################################
(>&2 echo "Remediating rule 6/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-disable_form_history'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


_tree['policies']['DisableFormHistory'] = True

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-disable_form_history'

###############################################################################
# BEGIN fix (7 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-disable_pocket'
###############################################################################
(>&2 echo "Remediating rule 7/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-disable_pocket'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


_tree['policies']['DisablePocket'] = True

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-disable_pocket'

###############################################################################
# BEGIN fix (8 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-disable_studies'
###############################################################################
(>&2 echo "Remediating rule 8/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-disable_studies'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


_tree['policies']['DisableFirefoxStudies'] = True

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-disable_studies'

###############################################################################
# BEGIN fix (9 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-dns_over_https'
###############################################################################
(>&2 echo "Remediating rule 9/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-dns_over_https'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'DNSOverHTTPS' in _tree['policies']:
   pass
else:
   _tree['policies']['DNSOverHTTPS'] = dict()

_tree['policies']['DNSOverHTTPS']['Enabled'] = False

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-dns_over_https'

###############################################################################
# BEGIN fix (10 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-encrypted_media_extensions'
###############################################################################
(>&2 echo "Remediating rule 10/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-encrypted_media_extensions'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'EncryptedMediaExtensions' in _tree['policies']:
   pass
else:
   _tree['policies']['EncryptedMediaExtensions'] = dict()

_tree['policies']['EncryptedMediaExtensions']['Enabled'] = False


if 'EncryptedMediaExtensions' in _tree['policies']:
   pass
else:
   _tree['policies']['EncryptedMediaExtensions'] = dict()

_tree['policies']['EncryptedMediaExtensions']['Locked'] = True

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-encrypted_media_extensions'

###############################################################################
# BEGIN fix (11 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-enhanced_tracking'
###############################################################################
(>&2 echo "Remediating rule 11/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-enhanced_tracking'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'Preferences' in _tree['policies']:
   pass
else:
   _tree['policies']['Preferences'] = dict()

if 'browser.contentblocking.category' in _tree['policies']['Preferences']:
   pass
else:
   _tree['policies']['Preferences']['browser.contentblocking.category'] = dict()

_tree['policies']['Preferences']['browser.contentblocking.category']['Value'] = 'strict'


if 'Preferences' in _tree['policies']:
   pass
else:
   _tree['policies']['Preferences'] = dict()

if 'browser.contentblocking.category' in _tree['policies']['Preferences']:
   pass
else:
   _tree['policies']['Preferences']['browser.contentblocking.category'] = dict()

_tree['policies']['Preferences']['browser.contentblocking.category']['Status'] = 'locked'

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-enhanced_tracking'

###############################################################################
# BEGIN fix (12 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-extension_recommendation'
###############################################################################
(>&2 echo "Remediating rule 12/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-extension_recommendation'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'Preferences' in _tree['policies']:
   pass
else:
   _tree['policies']['Preferences'] = dict()

if 'extensions.htmlaboutaddons.recommendations.enabled' in _tree['policies']['Preferences']:
   pass
else:
   _tree['policies']['Preferences']['extensions.htmlaboutaddons.recommendations.enabled'] = dict()

_tree['policies']['Preferences']['extensions.htmlaboutaddons.recommendations.enabled']['Value'] = False


if 'Preferences' in _tree['policies']:
   pass
else:
   _tree['policies']['Preferences'] = dict()

if 'extensions.htmlaboutaddons.recommendations.enabled' in _tree['policies']['Preferences']:
   pass
else:
   _tree['policies']['Preferences']['extensions.htmlaboutaddons.recommendations.enabled'] = dict()

_tree['policies']['Preferences']['extensions.htmlaboutaddons.recommendations.enabled']['Status'] = 'locked'

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-extension_recommendation'

###############################################################################
# BEGIN fix (13 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-extension_update'
###############################################################################
(>&2 echo "Remediating rule 13/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-extension_update'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


_tree['policies']['ExtensionUpdate'] = False

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-extension_update'

###############################################################################
# BEGIN fix (14 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-feedback_reporting'
###############################################################################
(>&2 echo "Remediating rule 14/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-feedback_reporting'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


_tree['policies']['DisableFeedbackCommands'] = True

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-feedback_reporting'

###############################################################################
# BEGIN fix (15 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-fingerprinting_protection'
###############################################################################
(>&2 echo "Remediating rule 15/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-fingerprinting_protection'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'EnableTrackingProtection' in _tree['policies']:
   pass
else:
   _tree['policies']['EnableTrackingProtection'] = dict()

_tree['policies']['EnableTrackingProtection']['Fingerprinting'] = True

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-fingerprinting_protection'

###############################################################################
# BEGIN fix (16 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-forget_button'
###############################################################################
(>&2 echo "Remediating rule 16/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-forget_button'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


_tree['policies']['DisableForgetButton'] = True

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-forget_button'

###############################################################################
# BEGIN fix (17 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-javascript_window_changes'
###############################################################################
(>&2 echo "Remediating rule 17/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-javascript_window_changes'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'Preferences' in _tree['policies']:
   pass
else:
   _tree['policies']['Preferences'] = dict()

if 'dom.disable_window_flip' in _tree['policies']['Preferences']:
   pass
else:
   _tree['policies']['Preferences']['dom.disable_window_flip'] = dict()

_tree['policies']['Preferences']['dom.disable_window_flip']['Value'] = True


if 'Preferences' in _tree['policies']:
   pass
else:
   _tree['policies']['Preferences'] = dict()

if 'dom.disable_window_flip' in _tree['policies']['Preferences']:
   pass
else:
   _tree['policies']['Preferences']['dom.disable_window_flip'] = dict()

_tree['policies']['Preferences']['dom.disable_window_flip']['Status'] = 'locked'

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-javascript_window_changes'

###############################################################################
# BEGIN fix (18 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-javascript_window_resizing'
###############################################################################
(>&2 echo "Remediating rule 18/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-javascript_window_resizing'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'Preferences' in _tree['policies']:
   pass
else:
   _tree['policies']['Preferences'] = dict()

if 'dom.disable_window_move_resize' in _tree['policies']['Preferences']:
   pass
else:
   _tree['policies']['Preferences']['dom.disable_window_move_resize'] = dict()

_tree['policies']['Preferences']['dom.disable_window_move_resize']['Value'] = True


if 'Preferences' in _tree['policies']:
   pass
else:
   _tree['policies']['Preferences'] = dict()

if 'dom.disable_window_move_resize' in _tree['policies']['Preferences']:
   pass
else:
   _tree['policies']['Preferences']['dom.disable_window_move_resize'] = dict()

_tree['policies']['Preferences']['dom.disable_window_move_resize']['Status'] = 'locked'

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-javascript_window_resizing'

###############################################################################
# BEGIN fix (19 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-network_prediction'
###############################################################################
(>&2 echo "Remediating rule 19/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-network_prediction'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


_tree['policies']['NetworkPrediction'] = False

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-network_prediction'

###############################################################################
# BEGIN fix (20 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-no_sanitize_on_shutdown'
###############################################################################
(>&2 echo "Remediating rule 20/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-no_sanitize_on_shutdown'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'SanitizeOnShutdown' in _tree['policies']:
   pass
else:
   _tree['policies']['SanitizeOnShutdown'] = dict()

_tree['policies']['SanitizeOnShutdown']['Cache'] = False


if 'SanitizeOnShutdown' in _tree['policies']:
   pass
else:
   _tree['policies']['SanitizeOnShutdown'] = dict()

_tree['policies']['SanitizeOnShutdown']['Cookies'] = False


if 'SanitizeOnShutdown' in _tree['policies']:
   pass
else:
   _tree['policies']['SanitizeOnShutdown'] = dict()

_tree['policies']['SanitizeOnShutdown']['Downloads'] = False


if 'SanitizeOnShutdown' in _tree['policies']:
   pass
else:
   _tree['policies']['SanitizeOnShutdown'] = dict()

_tree['policies']['SanitizeOnShutdown']['FormData'] = False


if 'SanitizeOnShutdown' in _tree['policies']:
   pass
else:
   _tree['policies']['SanitizeOnShutdown'] = dict()

_tree['policies']['SanitizeOnShutdown']['History'] = False


if 'SanitizeOnShutdown' in _tree['policies']:
   pass
else:
   _tree['policies']['SanitizeOnShutdown'] = dict()

_tree['policies']['SanitizeOnShutdown']['Sessions'] = False


if 'SanitizeOnShutdown' in _tree['policies']:
   pass
else:
   _tree['policies']['SanitizeOnShutdown'] = dict()

_tree['policies']['SanitizeOnShutdown']['SiteSettings'] = False


if 'SanitizeOnShutdown' in _tree['policies']:
   pass
else:
   _tree['policies']['SanitizeOnShutdown'] = dict()

_tree['policies']['SanitizeOnShutdown']['OfflineApps'] = False


if 'SanitizeOnShutdown' in _tree['policies']:
   pass
else:
   _tree['policies']['SanitizeOnShutdown'] = dict()

_tree['policies']['SanitizeOnShutdown']['Locked'] = True

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-no_sanitize_on_shutdown'

###############################################################################
# BEGIN fix (21 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-nonessential_capabilities'
###############################################################################
(>&2 echo "Remediating rule 21/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-nonessential_capabilities'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'FirefoxHome' in _tree['policies']:
   pass
else:
   _tree['policies']['FirefoxHome'] = dict()

_tree['policies']['FirefoxHome']['Search'] = False


if 'FirefoxHome' in _tree['policies']:
   pass
else:
   _tree['policies']['FirefoxHome'] = dict()

_tree['policies']['FirefoxHome']['TopSites'] = False


if 'FirefoxHome' in _tree['policies']:
   pass
else:
   _tree['policies']['FirefoxHome'] = dict()

_tree['policies']['FirefoxHome']['SponsoredTopSites'] = False


if 'FirefoxHome' in _tree['policies']:
   pass
else:
   _tree['policies']['FirefoxHome'] = dict()

_tree['policies']['FirefoxHome']['Pocket'] = False


if 'FirefoxHome' in _tree['policies']:
   pass
else:
   _tree['policies']['FirefoxHome'] = dict()

_tree['policies']['FirefoxHome']['SponsoredPocket'] = False


if 'FirefoxHome' in _tree['policies']:
   pass
else:
   _tree['policies']['FirefoxHome'] = dict()

_tree['policies']['FirefoxHome']['Highlights'] = False


if 'FirefoxHome' in _tree['policies']:
   pass
else:
   _tree['policies']['FirefoxHome'] = dict()

_tree['policies']['FirefoxHome']['Snippets'] = False


if 'FirefoxHome' in _tree['policies']:
   pass
else:
   _tree['policies']['FirefoxHome'] = dict()

_tree['policies']['FirefoxHome']['locked'] = True

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-nonessential_capabilities'

###############################################################################
# BEGIN fix (22 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-password_manager'
###############################################################################
(>&2 echo "Remediating rule 22/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-password_manager'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


_tree['policies']['PasswordManagerEnabled'] = False

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-password_manager'

###############################################################################
# BEGIN fix (23 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-pop-up_windows'
###############################################################################
(>&2 echo "Remediating rule 23/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-pop-up_windows'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'PopupBlocking' in _tree['policies']:
   pass
else:
   _tree['policies']['PopupBlocking'] = dict()

_tree['policies']['PopupBlocking']['Default'] = True


if 'PopupBlocking' in _tree['policies']:
   pass
else:
   _tree['policies']['PopupBlocking'] = dict()

_tree['policies']['PopupBlocking']['Locked'] = True

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-pop-up_windows'

###############################################################################
# BEGIN fix (24 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-private_browsing'
###############################################################################
(>&2 echo "Remediating rule 24/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-private_browsing'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


_tree['policies']['DisablePrivateBrowsing'] = True

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-private_browsing'

###############################################################################
# BEGIN fix (25 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-search_suggestion'
###############################################################################
(>&2 echo "Remediating rule 25/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-search_suggestion'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


_tree['policies']['SearchSuggestEnabled'] = False

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-search_suggestion'

###############################################################################
# BEGIN fix (26 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-search_update'
###############################################################################
(>&2 echo "Remediating rule 26/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-search_update'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'Preferences' in _tree['policies']:
   pass
else:
   _tree['policies']['Preferences'] = dict()

if 'browser.search.update' in _tree['policies']['Preferences']:
   pass
else:
   _tree['policies']['Preferences']['browser.search.update'] = dict()

_tree['policies']['Preferences']['browser.search.update']['Value'] = False


if 'Preferences' in _tree['policies']:
   pass
else:
   _tree['policies']['Preferences'] = dict()

if 'browser.search.update' in _tree['policies']['Preferences']:
   pass
else:
   _tree['policies']['Preferences']['browser.search.update'] = dict()

_tree['policies']['Preferences']['browser.search.update']['Status'] = 'locked'

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-search_update'

###############################################################################
# BEGIN fix (27 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-ssl_minimum_version'
###############################################################################
(>&2 echo "Remediating rule 27/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-ssl_minimum_version'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


_tree['policies']['SSLVersionMin'] = 'tls1.2'

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-ssl_minimum_version'

###############################################################################
# BEGIN fix (28 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-sync'
###############################################################################
(>&2 echo "Remediating rule 28/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-sync'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


_tree['policies']['DisableFirefoxAccounts'] = True

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-sync'

###############################################################################
# BEGIN fix (29 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-telemetry'
###############################################################################
(>&2 echo "Remediating rule 29/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-telemetry'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


_tree['policies']['DisableTelemetry'] = True

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-telemetry'

###############################################################################
# BEGIN fix (30 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-user_messaging'
###############################################################################
(>&2 echo "Remediating rule 30/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-user_messaging'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'UserMessaging' in _tree['policies']:
   pass
else:
   _tree['policies']['UserMessaging'] = dict()

_tree['policies']['UserMessaging']['ExtensionRecommendations'] = False

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-user_messaging'

###############################################################################
# BEGIN fix (31 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_policy-verification'
###############################################################################
(>&2 echo "Remediating rule 31/34: 'xccdf_org.ssgproject.content_rule_firefox_policy-verification'")

firefox_cfg="policies.json"
# Default to /etc/firefox/policies to use for remediations.
firefox_dirs="/etc/firefox/policies"
permissions=644

declare __REMEDIATE_PYTHON
if [ -x /usr/bin/python ]; then
    __REMEDIATE_PYTHON=/usr/bin/python
elif [ -x /usr/bin/python3 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python3
elif [ -x /usr/bin/python2 ]; then
    __REMEDIATE_PYTHON=/usr/bin/python2
else
    echo "Python required and no python interpreter found."
    exit 1
fi
declare __FIREFOX_DISTRIBUTION
if find /usr -iname firefox\* -type f -print | grep -qe "firefox.sh$\|firefox-bin$"; then
   __FIREFOX_DISTRIBUTION=$(dirname "$(find /usr -iname firefox\* -type f -print | grep -e "firefox.sh$\|firefox-bin$" | head -n1)")/distribution
fi
# If there's a policies file in the distribution directory already, modify it.
if [ -f ${__FIREFOX_DISTRIBUTION}/policies.json ]; then
        firefox_dirs="${__FIREFOX_DISTRIBUTION}"
fi
# Check the possible Firefox install directories
for firefox_dir in ${firefox_dirs}; do
    if ! [ -d "${firefox_dir}" ]; then
        mkdir -p "${firefox_dir}"
        chmod 755 "${firefox_dir}"
    fi
    # Make sure the Firefox .cfg file exists and has the appropriate permissions
    if ! [ -f "${firefox_dir}/${firefox_cfg}" ] ; then
        echo "{" > "${firefox_dir}/${firefox_cfg}"
        echo "    \"policies\": {" >> "${firefox_dir}/${firefox_cfg}"
        echo "    }" >> "${firefox_dir}/${firefox_cfg}"
        echo "}" >> "${firefox_dir}/${firefox_cfg}"
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
    # If the key exists, change it. Otherwise, add it to the config_file.
    if [ -x ${__REMEDIATE_PYTHON} ]; then
        echo """
import json
_file=open('${firefox_dir}/${firefox_cfg}', 'r')
_tree=json.load(_file)
_file.close()


if 'Preferences' in _tree['policies']:
   pass
else:
   _tree['policies']['Preferences'] = dict()

if 'security.default_personal_cert' in _tree['policies']['Preferences']:
   pass
else:
   _tree['policies']['Preferences']['security.default_personal_cert'] = dict()

_tree['policies']['Preferences']['security.default_personal_cert']['Value'] = 'Ask Every Time'


if 'Preferences' in _tree['policies']:
   pass
else:
   _tree['policies']['Preferences'] = dict()

if 'security.default_personal_cert' in _tree['policies']['Preferences']:
   pass
else:
   _tree['policies']['Preferences']['security.default_personal_cert'] = dict()

_tree['policies']['Preferences']['security.default_personal_cert']['Status'] = 'locked'

_file=open('${firefox_dir}/${firefox_cfg}', 'w')
json.dump(_tree, _file, indent=4, sort_keys=True)
_file.close()
""" | ${__REMEDIATE_PYTHON}
        chmod ${permissions} "${firefox_dir}/${firefox_cfg}"
    fi
done

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_policy-verification'

###############################################################################
# BEGIN fix (32 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_preferences-auto-download_actions'
###############################################################################
(>&2 echo "Remediating rule 32/34: 'xccdf_org.ssgproject.content_rule_firefox_preferences-auto-download_actions'")
(>&2 echo "FIX FOR THIS RULE 'xccdf_org.ssgproject.content_rule_firefox_preferences-auto-download_actions' IS MISSING!")

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_preferences-auto-download_actions'

###############################################################################
# BEGIN fix (33 / 34) for 'xccdf_org.ssgproject.content_rule_installed_firefox_version_supported'
###############################################################################
(>&2 echo "Remediating rule 33/34: 'xccdf_org.ssgproject.content_rule_installed_firefox_version_supported'")
(>&2 echo "FIX FOR THIS RULE 'xccdf_org.ssgproject.content_rule_installed_firefox_version_supported' IS MISSING!")

# END fix for 'xccdf_org.ssgproject.content_rule_installed_firefox_version_supported'

###############################################################################
# BEGIN fix (34 / 34) for 'xccdf_org.ssgproject.content_rule_firefox_preferences-dod_root_certificate_installed'
###############################################################################
(>&2 echo "Remediating rule 34/34: 'xccdf_org.ssgproject.content_rule_firefox_preferences-dod_root_certificate_installed'")
(>&2 echo "FIX FOR THIS RULE 'xccdf_org.ssgproject.content_rule_firefox_preferences-dod_root_certificate_installed' IS MISSING!")

# END fix for 'xccdf_org.ssgproject.content_rule_firefox_preferences-dod_root_certificate_installed'

