#! /bin/bash

[[ -n "${TRACE:-}" ]] && set -x

set -u

# Create unprivileged system (uid<1000) user for auxiliary processes.
_create_unpriv_user() {
    if $upgrade_traps; then

        unprivileged_user="$(config_get "$config_pmd" "analyzerd_user")"
    fi

    # Resolve absolute path for nologin.
    if [[ -f "/usr/sbin/nologin" ]]; then
        declare -r nologin="/usr/sbin/nologin"
    elif [[ -f "/sbin/nologin" ]]; then
        declare -r nologin="/sbin/nologin"
    else
        declare -r nologin="/bin/false"
    fi

    if id "$unprivileged_user" >/dev/null 2>&1; then
        return 0
    fi

    if ! useradd -r -M -s "$nologin" "$unprivileged_user" >/dev/null; then
        return 1
    fi

    config_set "$config_pmd" "analyzerd_user" "$unprivileged_user"
    return 0
}

setup_unprivileged_daemons() {

    config_fix "$config_pmd" "clad_only" ""

    chmod -R   g+xr,o+xr  "$deploy_dir/analyzerd/"

    if [[ -d "$deploy_dir/glibc" ]]; then
        chmod g+x       "$deploy_dir/glibc/"
        chmod g+x       "$deploy_dir/glibc/lib/"
        chmod g+x       "$deploy_dir/glibc/lib/x86_64-linux-gnu/"
        chmod g+xr,o+xr "$deploy_dir/glibc/lib/x86_64-linux-gnu/ld-2.19.so"
        chmod g+xr,o+xr "$deploy_dir/glibc/lib/x86_64-linux-gnu/libc.so.6"
        chmod g+xr,o+xr "$deploy_dir/glibc/lib/x86_64-linux-gnu/libdl.so.2"
        chmod g+xr,o+xr "$deploy_dir/glibc/lib/x86_64-linux-gnu/libm.so.6"
        chmod g+xr,o+xr "$deploy_dir/glibc/lib/x86_64-linux-gnu/libpthread.so.0"
        chmod g+xr,o+xr "$deploy_dir/glibc/lib/x86_64-linux-gnu/librt.so.1"
    fi
    chmod g+xr,o+xr "$deploy_dir/lib/libPocoFoundation.so.94"
    chmod g+xr,o+xr "$deploy_dir/lib/libPocoCrypto.so.94"
    chmod g+xr,o+xr "$deploy_dir/lib/libcrypto.so.1.0.0"
    chmod g+xr,o+xr "$deploy_dir/lib/libssl.so.1.0.0"
    chmod g+xr,o+xr "$deploy_dir/lib/libprotobuf.so.32"
    chmod g+xr,o+xr "$deploy_dir/lib/libprotoc.so.32"
    chmod g+xr,o+xr "$deploy_dir/lib/libyara.so.4"
    chmod g+xr,o+xr "$deploy_dir/lib/libgcc_s.so.1"
    chmod g+xr,o+xr "$deploy_dir/lib/libstdc++.so.6"

    # Create an unprivileged user.
    step_start "Creating/Verifying Cortex XDR auxiliary user"
    if ! _create_unpriv_user; then
        error "Unable to create Cortex XDR auxiliary user."
        return 1
    fi
    step_end

    return 0
}
