#! /bin/bash

[[ -n "${TRACE:-}" ]] && set -x

set -u

config_has() {
    declare -r filename="$1"
    declare -r element="$2"

    grep -q \
        "<$element>\(.*\)<\/$element>" \
        "$filename"
}

config_get() {
    declare -r filename="$1"
    declare -r element="$2"

    sed -n \
        -e "s/.*<$element>\(.*\)<\/$element>.*/\1/p" \
        "$filename"
}

config_set() {
    declare -r filename="$1"
    declare -r element="$2"
    declare -r value="$3"

    sed -i \
        -e "s^<$element>.*</$element>^<$element>$value</$element>^" \
        "$filename"
}

config_append() {
    declare -r filename="$1"
    declare -r element="$2"
    declare -r value="$3"
    declare -r parent_element="${4:-config}"

    declare -r indentation="$(sed -n \
        -e "s/^\(\s*\)<\/$parent_element>.*/\1/p" \
        "$filename")"

    sed -i \
        -e "\^</$parent_element>^ i \    $indentation<$element>$value</$element>" \
        "$filename"
}

config_fix() {
    declare -r filename="$1"
    declare -r element="$2"
    declare -r value="$3"
    declare -r parent_element="${4:-config}"

    if config_has "$filename" "$element"; then
        config_set "$filename" "$element" "$value"
    else
        config_append "$filename" "$element" "$value" "$parent_element"
    fi
}

config_fix_dynamic_feature() {
    declare -r filename="$1"
    declare -r element="$2"
    declare -r value="${3:-}"

    declare dynamic_features="$(config_get "$filename" "dynamic_features")"
    declare dynamic_features="${dynamic_features:+${dynamic_features},}$element${value:+=$value}"
    config_fix "$filename" "dynamic_features" "$dynamic_features"
}

config_pass() {
    declare -r old_config="$1"
    declare -r new_config="$2"
    declare -r element="$3"
    declare -r parent_element="${4:-config}"

    if ! config_has "$old_config" "$element"; then
        return 0
    fi

    declare -r old_value="$(config_get "$old_config" "$element")"
    config_fix "$new_config" "$element" "$old_value" "$parent_element"
}

config_override() {
    declare -r src_config="$1"
    declare -r dst_config="$2"

    declare -r sep=">"
    declare -r tag_long_regex="\s*<(.+)>(.*)<\/(\1)>\s*"
    declare -r tag_short_regex="\s*<(\S+)\s*()\/>\s*"
    declare -r sed_out='\1'"$sep"'\2'

    declare key_val_short="$(sed -rn 's/'"$tag_short_regex/$sed_out"'/p' "$src_config")"
    declare key_val_long="$(sed -rn 's/'"$tag_long_regex/$sed_out"'/p' "$src_config")"

    if [[ -z "$key_val_short" ]] && [[ -z "$key_val_long" ]]; then
        return 1
    fi

    if [[ -n "$key_val_short" ]]; then
        while IFS="$sep" read -r key val; do config_fix "$dst_config" "$key" "$val"; done <<< "$key_val_short"
    fi

    if [[ -n "$key_val_long" ]]; then
        while IFS="$sep" read -r key val; do config_fix "$dst_config" "$key" "$val"; done <<< "$key_val_long"
    fi
}

