#! /bin/bash

[[ -n "${TRACE:-}" ]] && set -x

set -u

_all_daemons() {
    echo "traps_pmd"
}

_resolve_init() {
    # Resolve init system.
    if [[ -n "${initd:-}" ]]; then
        echo "$initd"
    fi

    if [[ -f "/proc/1/comm" ]]; then
        cat "/proc/1/comm"
    else
        echo "init"
    fi
}

_is_upstart() {
    init --version > /dev/null 2>&1
}

_setup_daemons_init() {
    declare -r init_d_dir="/etc/init.d"
    declare -r init_dir="/etc/init"

    declare is_upstart=false
    if _is_upstart; then
        is_upstart=true
    fi

    if $is_upstart; then
        for name in "${all_daemons[@]}"; do
            cp "$deploy_dir/init/$name.conf" "$init_dir/$name.conf"
        done
    else
        for name in "${all_daemons[@]}"; do
            cp "$deploy_dir/init.d/$name" "$init_d_dir/$name"
            chmod u=rwx,go=r "$init_d_dir/$name"
        done
    fi

    # Copy systemd files in case of update from initd to systemd (eg. Ubuntu 14 -> 16).
    mkdir -p "$systemd_dir/"
    mkdir -p "$systemd_dir/multi-user.target.wants/"
    for name in "${all_daemons[@]}"; do
        cp "$deploy_dir/systemd/$name.service" "$systemd_dir/"
        cp "$deploy_dir/systemd/$name.service" "$systemd_dir/multi-user.target.wants/"
        chmod u=rw,go=r "$systemd_dir/$name.service"
    done
}

_setup_daemons_systemd() {
    for name in "${all_daemons[@]}"; do
        cp "$deploy_dir/systemd/$name.service" "$systemd_dir/$name.service"
        chmod u=rw,go=r "$systemd_dir/$name.service"
        systemctl enable "$name.service"
    done
}

uninstall_retired_daemons() {
    if $in_container; then
        return 0
    fi

    declare -r initd="$(_resolve_init)"
    declare -r systemd_dir="/etc/systemd/system"
    declare -r init_dir="/etc/init"

    if [[ "$initd" == "init" ]]; then
        if _is_upstart; then
            rm -f "$init_dir/traps_trapsd.conf"
        else
            rm -f "$init_d_dir/traps_trapsd"
        fi
    else
        # It's ok if command fails.
        systemctl disable traps_trapsd 2>/dev/null || true
    fi

    # The systemd files are always copied to accomodate initd upgrades.
    rm -f "$systemd_dir/traps_trapsd.service"
}

daemons_setup() {
    if $in_container; then
        return 0
    fi

    declare -r systemd_dir="/etc/systemd/system"
    declare -r -a all_daemons=($(_all_daemons))
    declare -r initd="$(_resolve_init)"

    step_start "Defining Cortex XDR local services ($initd)"
    if [[ "$initd" == "init" ]]; then
        _setup_daemons_init
    else
        _setup_daemons_systemd
    fi
    step_end

    return 0
}
