#! /bin/bash

[[ -n "${TRACE:-}" ]] && set -x

set -u

has_fapolicyd_installed() {

    local fapolicyd_service_is_enabled_out="$(systemctl is-enabled fapolicyd --no-pager 2>/dev/null)"

    if [[ "$fapolicyd_service_is_enabled_out" =~ ^(enabled|enabled-runtime|linked|linked-runtime|alias|masked|masked-runtime|static|disabled|indirect|generated|transient)$ ]]; then
        return 0
    fi

    return 1
}

setup_fapolicyd() {
    local start_fapolicy_comment="# Palo Alto Cortex XDR Exception"
    local cortex_access_all="allow perm=any dir=$deploy_dir : all"
    local load_libmodule_for_all="allow perm=open all : ftype=application/x-sharedlib dir=/opt/traps/lib"
    local cortex_fapolicyd_exception="${cortex_access_all}\n${load_libmodule_for_all}"
    local end_fapolicy_comment="# End Palo Alto Cortex XDR Exception"
    local full_exception="\n${start_fapolicy_comment}\n${cortex_fapolicyd_exception}\n${end_fapolicy_comment}\n"

    # fapolicyd >= 1.0.5
    if [[ -d "/etc/fapolicyd/rules.d" ]]; then
        printf "$full_exception" > "/etc/fapolicyd/rules.d/11-cortex-agent.rules"
    # fapolicyd < 1.0.5
    elif [[ -f "/etc/fapolicyd/fapolicyd.rules" ]]; then
        sed -i '1 i\'"$full_exception" /etc/fapolicyd/fapolicyd.rules
    else
        echo "INFO: fapolicyd service detected but no rule file/folder found"
        return 1
    fi

    local fapolicyd_status="$(systemctl is-active --quiet fapolicyd; echo $?)"
    if [[ "$fapolicyd_status" -eq 0 ]]; then
        systemctl restart fapolicyd || true
    fi

    return 0
}
