#! /bin/bash

[[ -n "${TRACE:-}" ]] && set -x

set -u

declare -r install_log_default="/var/log/traps-install.log"
declare install_log="${TRAPS_INSTALL_LOG-$install_log_default}"

setup_installer_log() {
    declare -r title="$1"

    if [[ -n "$install_log" ]]; then
        echo "============ $title $(date +"%d/%m/%Y %H:%M:%S") ============" >> "$install_log"
        if [ "$install_log" != "/dev/null" ]; then
            chmod 600 "$install_log" 2>/dev/null
        fi
        exec &> >(tee -a "$install_log")
    else

        install_log="/dev/null"
    fi
}