#! /bin/bash

[[ -n "${TRACE:-}" ]] && set -x

set -u

setup_selinux() {
    declare -r deploy_dir="$deploy_dir"
    declare -r upgrade_traps="$upgrade_traps"
    declare -r config_common="$config_common"
    declare -r libmodule_64="$libmodule_64"
    declare -r libmoduleng_64="$libmoduleng_64"
    declare -r libmodule_32="$libmodule_32"
    declare -r libmoduleng_32="$libmoduleng_32"
    declare -r has_selinux="$has_selinux"

    step_start "Installing SELinux policies"

    cp "/usr/share/selinux/devel/Makefile" "$deploy_dir/selinux/Makefile"
    if [[ $? -ne 0 ]]; then
        error "Missing SELinux policy build necessities."
        return 1
    fi

    echo -n "  Compiling ... "
    make -C "$deploy_dir/selinux/" -s "traps.pp" > /dev/null
    if [[ $? -ne 0 ]]; then
        notice_bad "ERROR"
        error "Failed compiling SELinux policies."
        return 1
    fi
    notice_good "OK"

    echo -n "  Installing ... "
    semodule -i "$deploy_dir/selinux/traps.pp"
    case "$?" in
        0)
            notice_good "OK"
            ;;

        127)
            notice_bad "ERROR"
            error "Can't install without the \`semodule\` binary."
            return 1
            ;;

        *)
            notice_bad "ERROR ($?)"
            error "Failed installing SELinux policies."
            return 1
            ;;
    esac

    echo -n "  Updating contexts ... "
    if ! $upgrade_traps; then
        semanage fcontext -a -t traps_libmodule_t "$libmodule_32"
        semanage fcontext -a -t traps_libmodule_t "$libmodule_64"
        semanage fcontext -a -t traps_libmodule_t "$libmoduleng_32"
        semanage fcontext -a -t traps_libmodule_t "$libmoduleng_64"
    fi

    [[ -e "$libmodule_32" ]] && restorecon "$libmodule_32"
    [[ -e "$libmodule_64" ]] && restorecon "$libmodule_64"
    [[ -e "$libmoduleng_32" ]] && restorecon "$libmoduleng_32"
    [[ -e "$libmoduleng_64" ]] && restorecon "$libmoduleng_64"
    notice_good "OK"

    step_end

    return 0
}
