#! /bin/bash

[[ -n "${TRACE:-}" ]] && set -x

set -u

configure_temporary_workload() {

    if $is_temporary_session; then
        echo "Installing as a temporary session"
        config_fix "$config_trapsd" "ts_enabled" "1"
        config_fix "$config_trapsd" "vm_template" "0"
    elif $is_vm_template; then
        echo "Installing as a VM template"
        config_fix "$config_trapsd" "ts_enabled" "1"
        config_fix "$config_trapsd" "vm_template" "1"
    fi
}
