#! /bin/bash

[[ -n "${TRACE:-}" ]] && set -x

set -u

setup_apparmor() {
    declare -r deploy_dir="$deploy_dir"
    declare -r upgrade_traps="$upgrade_traps"
    declare -r has_apparmor="$has_apparmor"
    declare -r os_distribution="$(resolve_distro_name)"
    declare -r os_distribution_version="$(resolve_distro_major_version)"

    # Older distributions have older apparmor, and for them we need to use different rules file
    if [[ "$os_distribution" == "suse" && "$os_distribution_version" -eq 11 ]]; then
        declare -r apparmor_abstractions_file="pan-traps-legacy"
    elif [[ "$os_distribution" == "suse" && "$os_distribution_version" -eq 12 ]]; then
        declare -r apparmor_abstractions_file="pan-traps-legacy"
    elif [[ "$os_distribution" == "ubuntu" && "$os_distribution_version" -eq 12 ]]; then
        declare -r apparmor_abstractions_file="pan-traps-legacy"
    else
        declare -r apparmor_abstractions_file="pan-traps"
    fi

    # Setup AppArmor policies.
    # We always create the abstractions file to accomodate for AppArmor state changes.
    mkdir -p "/etc/apparmor.d/abstractions/"
    cp "$deploy_dir/apparmor/$apparmor_abstractions_file" "/etc/apparmor.d/abstractions/pan-traps"
    chmod 0644 "/etc/apparmor.d/abstractions/pan-traps"

    # Reload all executables which have 'pan-traps' abstractions in their apparmor policy
    if $has_apparmor; then
        if $upgrade_traps; then
            step_start "Updating AppArmor policies"
            for policy in $(find "/etc/apparmor.d/local/" -maxdepth 1 -type f); do
                if ! grep -q "#include <abstractions/pan-traps>" "$policy"; then
                    continue
                fi

                echo "  * $(basename $policy)"
                apparmor_parser -r "/etc/apparmor.d/$(basename $policy)"
            done

            step_end
        fi
    fi
}
