#! /bin/bash

[[ -n "${TRACE:-}" ]] && set -x

set -u

_check_for_iptables_installation() {
    local iptables_kernel_option="CONFIG_IP_NF_IPTABLES"
    local current_kernel="$(uname -r)"
    local kernel_option="$(grep "$iptables_kernel_option" "/boot/config-${current_kernel}" | cut -d'=' -f2)"
    local return_value="$?"

    # Kernelspace check
    if [ "$return_value" -eq "0" ]; then
        if [[ "$kernel_option" != "m" ]] && [[ "$kernel_option" != "y" ]]; then
            notice_warn "iptables kernel option ($iptables_kernel_option) disabled, network isolation will not work!"
            return 1
        fi
    else
        notice_warn "Unable to detect iptables kernel config, looking for user-space app"
    fi

    # Userspace check
    if ! command -v iptables &> /dev/null; then
        notice_warn "iptables not found, network isolation will not work!"
        return 1
    fi

    return 0
}